快速入门
=======

本文将简单介绍如何使用 Yu Writer  创建和编辑第一个文档，以及基本的文档格式。

## 新建文档

点击菜单 `File` > `New Document` 或者按下快捷键 `Command + N` 创建第一个文档（注：在 Windows 和 Linux 系统里对应的快捷键是 `Ctrl + N`）。

新建一个文档之后，你可以随时点击编辑器的标签页或者左侧文档库当中的文件名来回切换新文档和本文。为方便练习，也可以点击菜单 `File` > `Open Document in New Window` 让其中一个文档在新窗口中打开，这样就可以同时进行阅读和编辑了。

## 编辑文档

Yu Writer 的目标用户是专注于内容创作的作者，所以使用了一种近似纯文本的 Markdown [^1] 文档格式来书写文档。在 Yu Writer 里你不能像其他文字处理软件一样随意更改字体的大小、颜色和样式，也不能随意对段落、图片进行排版。

但使用 Markdown 可以轻松定义文档的组成元素，比如标题、链接、图片、列表等，而且书写过程中手指几乎不需要离开键盘（一般文字处理软件需要你停下来，先用鼠标或触控板选定文字，然后再添加或更改其样式），特别是在使用触控屏幕输入文字的设备上，使用 Markdown 格式来书写能最大限度地排除各种干扰因素，保持创作思路的连贯性和提高书写效率。而且 Yu Writer 的 `样式集` 功能可以将文档渲染成具有不同风格的专业文档。

### 基本格式

你可以像写纯文本一样书写文档内容，如果你想为某些文字赋予某些属性或者样式，加上一些符号标识即可，下面举两个例子。

#### 标题

在一行文字前面添加 `#` 号和一个空格可以将该行变成标题（Heading）。比如 1 个 `#` 号表示一级标题、2 个 `#` 号表示二级标题，如此类推，最多可以使用 6 个 `#` 号表示六级标题。

你也可以使用快捷键 `Command+1` 或者 `Command+2` 等为光标所在的行变为一级标题或者二级标题。（注：在 Windows 和 Linux 系统里对应的快捷键是 `Ctrl + 1`）。

#### 粗体、斜体和删除线

在词组的前后使用 `**` 包围起来表示加粗，使用 `_` 表示斜体，使用 `~~` 表示删除线，比如： **Bold**，_Italic_，~~Strikethrough~~。

你也可以使用快捷键 `Command+B` 和 `Command+I` 等为选中的文字变为粗体和斜体（注：在 Windows 和 Linux 系统里对应的快捷键是 `Ctrl + B` 和 `Ctrl + I`）。也可以选中文字后，直接输入字母 `b`，`i`，`s`，`c` 让它们变成粗体、斜体、删除线和代码。

### 链接和图片

如果想在文档里添加一个链接，可以使用这样的格式 `[Link Text](https://a.com)` 表示，其中中括号里面的是链接的文字，括号里面的是链接地址。当然直接输入一个网址它也会自动转换为链接。

如果链接地址是一个图片链接，则可以在链接代码前面添加一个 `!` 号让图片显示出来，比如 `![Image Text](https://a.com/b.jpg)`。

如果想在文档里插入本地（本机）的图片，先点击工具栏的 `Image（图片）` 按钮，然后把图片拖入弹出的小窗口中，再点击 `Insert` 按钮。

## 阅读模式和样式集

点击工具栏的 `Read Mode（阅读模式）` 按钮可以进入阅读模式，在这里你可以查看文档输出和打印的样子。在阅读模式窗口的下侧可以选择不同的样式集，不同的样式集用于把文档渲染成不同风格。

在阅读模式下，点击应用程序窗口的顶端可以快速把文档滚动到顶端（仅 macOS 系统里有效）。再次点击 `Read Mode` 按钮或者按 `ESC` 键可以退出阅读模式并返回编辑状态。

## 导出文档

在编辑状态下或者阅读模式里点击工具栏的 `Export` 按钮可以把文档导出为 PDF 文档或者 Wordpress 博客、微信公众号等所使用的 HTML 等格式。也可以导出为 Text Bundle 用于把文档分享给其他人。

[^1]: CommonMark http://commonmark.org/

* * *
返回 [目录](welcome)
